#include <genesis.h>
#include <resources.h>

#define IDLE_TRIGGER_FRAMES 600   // ~10 seconds
#define PAUSE_FRAMES        180   // 3 seconds
#define SCROLL_SPEED        2

void showMegaSplash(void)
{
    // ---- FULLY HIDE MENU ----
    JOY_setEventHandler(NULL);
    VDP_clearPlane(BG_A, TRUE);
    VDP_clearPlane(BG_B, TRUE);

    SPR_reset();
    SPR_init();

    // Use any splash sprite palette (they all match)
    PAL_setPalette(PAL0, tilerImg.palette->data, DMA);
    PAL_setPalette(PAL1, pongImg.palette->data, DMA);
    PAL_setPalette(PAL2, galagaImg.palette->data, DMA);
    PAL_setPalette(PAL3, runnerImg.palette->data, DMA);

    // ---- SPRITE WIDTHS (pixels) ---- Note: switched back to fixed integers due to odd compiling issues. 
    const s16 PONG_W   = 19 * 8;
    const s16 GALAGA_W = 19 * 8;
    const s16 RUNNER_W = 22 * 8;
    const s16 TILER_W  = 19 * 8;

    // ---- START POSITIONS ----
    s16 pongX   = -PONG_W;
    s16 galagaX = -GALAGA_W - 40;
    s16 runnerX = 320 + 40;
    s16 tilerX  = 320 + 80;

    // ---- DIFFERENT HEIGHTS (NO OVERLAP) ----
    s16 pongY   = 48;
    s16 galagaY = 80;
    s16 runnerY = 112;
    s16 tilerY  = 144;

    Sprite* pong   = SPR_addSprite(&pongImg,   pongX,   pongY,   TILE_ATTR(PAL1, FALSE, FALSE, FALSE));
    Sprite* galaga = SPR_addSprite(&galagaImg, galagaX, galagaY, TILE_ATTR(PAL2, FALSE, FALSE, FALSE));
    Sprite* runner = SPR_addSprite(&runnerImg, runnerX, runnerY, TILE_ATTR(PAL3, FALSE, FALSE, FALSE));
    Sprite* tiler  = SPR_addSprite(&tilerImg,  tilerX,  tilerY,  TILE_ATTR(PAL0, FALSE, FALSE, FALSE));

    // ---- SCROLL IN ----
    while (pongX < 84)
    {
        pongX   += SCROLL_SPEED;
        galagaX += SCROLL_SPEED;
        runnerX -= SCROLL_SPEED;
        tilerX  -= SCROLL_SPEED;

        SPR_setPosition(pong,   pongX,   pongY);
        SPR_setPosition(galaga, galagaX, galagaY);
        SPR_setPosition(runner, runnerX, runnerY);
        SPR_setPosition(tiler,  tilerX,  tilerY);

        SPR_update();
        SYS_doVBlankProcess();
    }

    // ---- PAUSE ----
    for (u16 i = 0; i < PAUSE_FRAMES; i++)
    {
        SPR_update();
        SYS_doVBlankProcess();
    }

    // ---- SCROLL OUT ----
    while (pongX < 360)
    {
        pongX   += SCROLL_SPEED;
        galagaX += SCROLL_SPEED;
        runnerX -= SCROLL_SPEED;
        tilerX  -= SCROLL_SPEED;

        SPR_setPosition(pong,   pongX,   pongY);
        SPR_setPosition(galaga, galagaX, galagaY);
        SPR_setPosition(runner, runnerX, runnerY);
        SPR_setPosition(tiler,  tilerX,  tilerY);

        SPR_update();
        SYS_doVBlankProcess();
    }

    // ---- CLEAN UP ----
    SPR_reset();
}
